﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Services.Client;
using HospitalModel;

namespace Rozdzial_23
{
    class Program
    {
        static void Main(string[] args)
        {
            PerformLinqQueryWithHospitalEntities();
            //PerformLinqQueryWithDataServiceContext();
            //InsertDataServiceEntity();
            //UpdateDataServiceEntity();
            //QueryDataService();
            //DeleteDataServiceEntity();
            Console.ReadKey();
        }
        private static void InsertDataServiceEntity()
        {
            var datCtx = new DataServiceContext(
                new Uri("http://localhost:1778/HospitalDataService.svc"));
            
            datCtx.AddObject("HospitalStaff",
                new HospitalStaff
                {
                    Name = "Darek",
                    Position = "Lekarz"
                });

            datCtx.SaveChanges();

         }
        private static void QueryDataService()
        {
            var datCtx = new DataServiceContext(
                new Uri("http://localhost:1778/HospitalDataService.svc"));

            var docs = datCtx.CreateQuery<HospitalStaff>("/HospitalStaff");

            docs.ToList().ForEach(
                doc => Console.WriteLine("Name: {0}", doc.Name));
        }
        private static void UpdateDataServiceEntity()
        {
            var datCtx = new DataServiceContext( new Uri ("http://localhost:1778/HospitalDataService.svc"));
                       
            datCtx.MergeOption = MergeOption.AppendOnly;
            var docs = datCtx.Execute<HospitalStaff>(new Uri (("/HospitalStaff?$filter=Name eq 'Darek'"),UriKind.Relative));
                
            var drNo = docs.First();
            drNo.Position = "Pielegniarka";
            datCtx.UpdateObject(drNo);

            datCtx.SaveChanges();

            docs = datCtx.CreateQuery<HospitalStaff>(
                "/HospitalStaff");

            docs.ToList().ForEach(
                doc => Console.WriteLine(
                    "Update - Name: {0}, Position: {1}",
                   doc.Name, doc.Position));
        }

        private static void DeleteDataServiceEntity()
        {
            var datCtx = new DataServiceContext(
                new Uri("http://localhost:1778/HospitalDataService.svc"));

            datCtx.MergeOption = MergeOption.AppendOnly;

            var docs = datCtx.Execute<HospitalStaff>(new Uri(("/HospitalStaff?$filter=Name eq 'Darek'"), UriKind.Relative));
                
            docs.ToList().ForEach(
                doc => datCtx.DeleteObject(doc));

            datCtx.SaveChanges();

            docs = datCtx.CreateQuery<HospitalStaff>(
                "/HospitalStaff");

            docs.ToList().ForEach(
                doc => Console.WriteLine(
                    "Delete - Name: {0}, Position: {1}",
                    doc.Name, doc.Position));
        }
        private static void PerformLinqQueryWithDataServiceContext()
        {
            var hospital = new DataServiceContext(
                new Uri("http://localhost:1778/HospitalDataService.svc"));

            var docs =
                from doc in hospital.CreateQuery<HospitalStaff>("/HospitalStaff")
                where doc.Position == "Lekarz"
                select new { doc.Name };

           docs.ToList().ForEach(doc => Console.WriteLine("LINQ with WebDataContext - Name: {0}", doc.Name));
            
        }

        private static void PerformLinqQueryWithHospitalEntities()
        {
            var hospital = new HospitalEntities(
                new Uri("http://localhost:1778/HospitalDataService.svc/"));

            var docs = from doc in hospital.HospitalStaff
                       where doc.Position == "Pielegniarka"
                       select new { doc.Name };
            
            
            docs.ToList().ForEach(
               doc => Console.WriteLine(
                "LINQ with HospitalEntities - Name: {0}", doc.Name));
        }

      }
}
